-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Versione server:              10.1.28-MariaDB - mariadb.org binary distribution
-- S.O. server:                  Win32
-- HeidiSQL Versione:            9.5.0.5196
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


-- Dump della struttura del database test
CREATE DATABASE IF NOT EXISTS `gestione` /*!40100 DEFAULT CHARACTER SET latin1 */;
USE `gestione`;

-- Dump della struttura di tabella test.biglietti
DROP TABLE IF EXISTS `biglietti`;
CREATE TABLE IF NOT EXISTS `biglietti` (
  `cod_operazione` int(11) NOT NULL AUTO_INCREMENT,
  `cod_cliente` int(11) DEFAULT NULL,
  `cod_replica` varchar(4) DEFAULT NULL,
  `data_ora` datetime DEFAULT NULL,
  `tipo_pagamento` varchar(20) DEFAULT NULL,
  `quantita` int(11) DEFAULT NULL,
  PRIMARY KEY (`cod_operazione`),
  KEY `cod_cliente` (`cod_cliente`),
  KEY `cod_replica` (`cod_replica`),
  CONSTRAINT `biglietti_ibfk_1` FOREIGN KEY (`cod_cliente`) REFERENCES `clienti` (`cod_cliente`),
  CONSTRAINT `biglietti_ibfk_2` FOREIGN KEY (`cod_replica`) REFERENCES `repliche` (`cod_replica`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=latin1;

-- Dump dei dati della tabella test.biglietti: ~21 rows (circa)
DELETE FROM `biglietti`;

-- Dump della struttura di tabella test.clienti
DROP TABLE IF EXISTS `clienti`;
CREATE TABLE IF NOT EXISTS `clienti` (
  `cod_cliente` int(11) NOT NULL AUTO_INCREMENT,
  `cognome` varchar(20) DEFAULT NULL,
  `nome` varchar(20) DEFAULT NULL,
  `telefono` varchar(14) DEFAULT NULL,
  `email` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`cod_cliente`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

-- Dump dei dati della tabella test.clienti: ~6 rows (circa)
DELETE FROM `clienti`;
/*!40000 ALTER TABLE `clienti` DISABLE KEYS */;
INSERT INTO `clienti` (`cod_cliente`, `cognome`, `nome`, `telefono`, `email`) VALUES
	(1, 'rossi', 'giada', '06/4328346', 'rossi@gmail.com'),
	(2, 'bellinellu', 'samantha', '06/79876658', 'bellinellu@yahoo.it'),
	(3, 'corizio', 'carlo', '06/76547648', 'corizio@libero.it'),
	(4, 'francini', 'cassandra', '06/76586548', 'francini@gmail.com'),
	(5, 'martorano', 'marco', '06/543326565', 'martorano@yahoo.com'),
	(6, 'fiorullo', 'erika', '06/98765762', 'fiorullo@hotmail.com');
/*!40000 ALTER TABLE `clienti` ENABLE KEYS */;

-- Dump della struttura di tabella test.musical
DROP TABLE IF EXISTS `musical`;
CREATE TABLE IF NOT EXISTS `musical` (
  `cod_musical` varchar(4) NOT NULL,
  `titolo` varchar(40) DEFAULT NULL,
  `autore` varchar(25) DEFAULT NULL,
  `regista` varchar(25) DEFAULT NULL,
  `prezzo` float(6,2) DEFAULT NULL,
  `cod_teatro` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`cod_musical`),
  KEY `cod_teatro` (`cod_teatro`),
  CONSTRAINT `musical_ibfk_1` FOREIGN KEY (`cod_teatro`) REFERENCES `teatri` (`cod_teatro`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dump dei dati della tabella test.musical: ~6 rows (circa)
DELETE FROM `musical`;
/*!40000 ALTER TABLE `musical` DISABLE KEYS */;
INSERT INTO `musical` (`cod_musical`, `titolo`, `autore`, `regista`, `prezzo`, `cod_teatro`) VALUES
	('s001', 'cats', 'andrew lloyd webber', 'trevor nunn', 50.00, 't001'),
	('s002', 'titanic', 'peter stone', 'maury teston', 50.00, 't001'),
	('s003', 'peter pan', 'mark moose charlap', 'jerome robbins', 65.00, 't002'),
	('s004', 'Oliver!', 'charles Dickens', 'Susan Atroman', 65.00, 't002'),
	('s005', 'Anastasia', 'Terrence McNally', 'Darko Tresnjak', 30.00, 't003'),
	('s006', 'Colazione da Tiffany', 'Truman Capote', 'Joseph Anthony', 30.00, 't003');
/*!40000 ALTER TABLE `musical` ENABLE KEYS */;

-- Dump della struttura di tabella test.repliche
DROP TABLE IF EXISTS `repliche`;
CREATE TABLE IF NOT EXISTS `repliche` (
  `cod_replica` varchar(4) NOT NULL,
  `cod_musical` varchar(4) DEFAULT NULL,
  `data_replica` date DEFAULT NULL,
  PRIMARY KEY (`cod_replica`),
  KEY `cod_musical` (`cod_musical`),
  CONSTRAINT `repliche_ibfk_1` FOREIGN KEY (`cod_musical`) REFERENCES `musical` (`cod_musical`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dump dei dati della tabella test.repliche: ~30 rows (circa)
DELETE FROM `repliche`;
/*!40000 ALTER TABLE `repliche` DISABLE KEYS */;
INSERT INTO `repliche` (`cod_replica`, `cod_musical`, `data_replica`) VALUES
	('r001', 's001', '2018-10-05'),
	('r002', 's001', '2018-10-06'),
	('r003', 's001', '2018-10-07'),
	('r004', 's001', '2018-10-08'),
	('r005', 's001', '2018-10-09'),
	('r006', 's002', '2018-11-12'),
	('r007', 's002', '2018-11-13'),
	('r008', 's002', '2018-11-14'),
	('r009', 's002', '2018-11-15'),
	('r010', 's002', '2018-11-16'),
	('r011', 's003', '2019-01-05'),
	('r012', 's003', '2019-01-06'),
	('r013', 's003', '2019-01-07'),
	('r014', 's003', '2019-01-08'),
	('r015', 's003', '2019-01-09'),
	('r016', 's004', '2019-01-12'),
	('r017', 's004', '2019-01-13'),
	('r018', 's004', '2019-01-14'),
	('r019', 's004', '2019-01-15'),
	('r020', 's004', '2019-01-16'),
	('r021', 's005', '2018-11-05'),
	('r022', 's005', '2018-11-06'),
	('r023', 's005', '2018-11-07'),
	('r024', 's005', '2018-11-18'),
	('r025', 's005', '2018-11-19'),
	('r026', 's006', '2018-12-12'),
	('r027', 's006', '2018-12-13'),
	('r028', 's006', '2018-12-14'),
	('r029', 's006', '2018-12-15'),
	('r030', 's006', '2018-12-16');
/*!40000 ALTER TABLE `repliche` ENABLE KEYS */;

-- Dump della struttura di tabella test.teatri
DROP TABLE IF EXISTS `teatri`;
CREATE TABLE IF NOT EXISTS `teatri` (
  `cod_teatro` varchar(4) NOT NULL,
  `nome` varchar(30) DEFAULT NULL,
  `indirizzo` varchar(30) DEFAULT NULL,
  `citta` varchar(25) DEFAULT NULL,
  `provincia` varchar(2) DEFAULT NULL,
  `telefono` varchar(14) DEFAULT NULL,
  `posti` int(11) DEFAULT NULL,
  PRIMARY KEY (`cod_teatro`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dump dei dati della tabella test.teatri: ~2 rows (circa)
DELETE FROM `teatri`;
/*!40000 ALTER TABLE `teatri` DISABLE KEYS */;
INSERT INTO `teatri` (`cod_teatro`, `nome`, `indirizzo`, `citta`, `provincia`, `telefono`, `posti`) VALUES
	('t001', 'teatro agora', 'via della penitenza, 33', 'roma', 'rm', '066874167', 265),
	('t002', 'teatro argentina', 'largo di torre argentina, 52', 'roma', 'rm', '06684000314', 405),
	('t003', 'teatro ambra jovinelli', 'via guglielmo pepe, 43', 'roma', 'rm', '0683082884', 392);
/*!40000 ALTER TABLE `teatri` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
